<?php

declare(strict_types=1);

namespace Amasty\FacebookPixelPro\Model\EventData\EventDataGenerator;

use Amasty\FacebookPixel\Api\Data\PixelInterface;

interface EventDataGeneratorInterface
{
    /**
     * @param null $eventObject
     * @return array|null
     */
    public function getEventData($eventObject = null): ?array;

    /**
     * @return string
     */
    public function getEventName(): string;

    /**
     * @param PixelInterface $pixel
     * @return bool
     */
    public function isEventEnabledForPixel(PixelInterface $pixel): bool;
}
