<?php

declare(strict_types=1);

namespace Amasty\FacebookPixelPro\Model\EventData\EventDataGenerator;

use Amasty\FacebookPixel\Api\Data\PixelInterface;
use Amasty\FacebookPixel\Model\EventData\EventDataGenerator\AddToWishlist as PixelAddToWishlist;

class AddToWishlist extends PixelAddToWishlist implements EventDataGeneratorInterface
{
    private const EVENT_NAME = 'AddToWishlist';

    /**
     * @param PixelInterface $pixel
     * @return bool
     */
    public function isEventEnabledForPixel(PixelInterface $pixel): bool
    {
        return (bool)$pixel->getExtensionAttributes()->getServerSideData()->getIsAddToWishlistEnabled();
    }

    /**
     * @return string
     */
    public function getEventName(): string
    {
        return self::EVENT_NAME;
    }
}
