<?php

declare(strict_types=1);

namespace Amasty\FacebookPixelPro\Model\EventData\EventDataGenerator;

use Amasty\FacebookPixel\Api\Data\PixelInterface;
use Amasty\FacebookPixel\Model\EventData\EventDataGenerator\AddToCart as AddToCartPixel;

class AddToCart extends AddToCartPixel implements EventDataGeneratorInterface
{
    private const EVENT_NAME = 'AddToCart';

    /**
     * @param PixelInterface $pixel
     * @return bool
     */
    public function isEventEnabledForPixel(PixelInterface $pixel): bool
    {
        return (bool)$pixel->getExtensionAttributes()->getServerSideData()->getIsAddToCartEnabled();
    }

    /**
     * @return string
     */
    public function getEventName(): string
    {
        return self::EVENT_NAME;
    }
}
