<?php

declare(strict_types=1);

namespace Amasty\FacebookPixelPro\Model;

use Amasty\Base\Model\ConfigProviderAbstract;

class ConfigProvider extends ConfigProviderAbstract
{
    /**
     * @var string
     */
    protected $pathPrefix = 'amasty_facebook_pixel/';

    public const GENERAL_BLOCK = 'general/';

    public const IS_DELAYED_DISPATCH_ENABLED = 'is_delayed_dispatch_enabled';

    /**
     * @return bool
     */
    public function isDelayedDispatchEnabled(): bool
    {
        return $this->isSetFlag(self::GENERAL_BLOCK . self::IS_DELAYED_DISPATCH_ENABLED);
    }
}
