<?php

declare(strict_types=1);

namespace Amasty\FacebookPixelPro\Model\Config\Source;

use Magento\Framework\Data\OptionSourceInterface;

class SendingFrequency implements OptionSourceInterface
{
    public const EACH_15_MINUTES = '*/15 * * * *';
    public const EACH_30_MINUTES = '*/30 * * * *';
    public const EACH_HOUR = '15 * * * *';

    /**
     * @return array
     */
    public function toOptionArray(): array
    {
        return [
            ['value' => self::EACH_15_MINUTES, 'label' => __('Once per 15 minutes')],
            ['value' => self::EACH_30_MINUTES, 'label' => __('Once per 30 minutes')],
            ['value' => self::EACH_HOUR, 'label' => __('Once per hour')],
        ];
    }
}
