<?php

declare(strict_types=1);

namespace Amasty\FacebookPixelPro\Model\Api;

use Magento\Framework\HTTP\Client\Curl;

class ApiCaller
{
    public const API_URL = 'https://graph.facebook.com/{API_VERSION}/{PIXEL_ID}/events?access_token={TOKEN}';
    public const API_VERSION = 'v12.0';

    /**
     * @var Curl
     */
    private $curl;

    public function __construct(Curl $curl)
    {
        $this->curl = $curl;
    }

    /**
     * @param string $pixelId
     * @param string $token
     * @param array $data
     * @param string|null $testEventCode
     */
    public function sendEvent(string $pixelId, string $token, array $data, ?string $testEventCode = null): void
    {
        $endpointUrl = $this->getEndpointUrl($pixelId, $token);

        $dataToSend = ['data' => $data];
        if ($testEventCode) {
            $dataToSend['test_event_code'] = $testEventCode;
        }

        $this->curl->post($endpointUrl, $dataToSend);
    }

    /**
     * @param string $pixelId
     * @param string $token
     * @return string
     */
    private function getEndpointUrl(string $pixelId, string $token): string
    {
        $url = str_replace('{API_VERSION}', self::API_VERSION, self::API_URL);
        $url = str_replace('{PIXEL_ID}', $pixelId, $url);

        return str_replace('{TOKEN}', $token, $url);
    }
}
