<?php

declare(strict_types=1);

namespace Amasty\FacebookPixelPro\Api;

use Amasty\FacebookPixelPro\Api\Data\ServerSideSettingsInterface;
use Magento\Framework\Api\SearchCriteriaInterface;
use Magento\Framework\Api\SearchResultsInterface;
use Magento\Framework\Exception;

interface ServerSideSettingsRepositoryInterface
{
    /**
     * @param ServerSideSettingsInterface $pixel
     * @return ServerSideSettingsInterface
     * @throws Exception\CouldNotSaveException
     */
    public function save(ServerSideSettingsInterface $pixel): ServerSideSettingsInterface;

    /**
     * @param int $entityId
     * @return ServerSideSettingsInterface
     * @throws Exception\NoSuchEntityException
     */
    public function getById(int $entityId): ServerSideSettingsInterface;

    /**
     * @param int $entityId
     * @return ServerSideSettingsInterface|null
     */
    public function findById(int $entityId): ?ServerSideSettingsInterface;

    /**
     * @param SearchCriteriaInterface $searchCriteria
     * @return SearchResultsInterface
     * @throws Exception\LocalizedException
     */
    public function getList(SearchCriteriaInterface $searchCriteria): SearchResultsInterface;

    /**
     * @param ServerSideSettingsInterface $pixel
     * @return bool
     * @throws Exception\CouldNotDeleteException
     */
    public function delete(ServerSideSettingsInterface $pixel): bool;

    /**
     * @param int $entityId
     * @return bool
     * @throws Exception\NoSuchEntityException
     * @throws Exception\CouldNotDeleteException
     */
    public function deleteById(int $entityId): bool;
}
