<?php

declare(strict_types=1);

namespace Amasty\FacebookPixelPro\Api;

use Amasty\FacebookPixelPro\Api\Data\EventQueueInterface;
use Magento\Framework\Api\SearchCriteriaInterface;
use Magento\Framework\Api\SearchResultsInterface;
use Magento\Framework\Exception;

interface EventQueueRepositoryInterface
{
    /**
     * @param EventQueueInterface $eventQueue
     * @return EventQueueInterface
     * @throws Exception\CouldNotSaveException
     */
    public function save(EventQueueInterface $eventQueue): EventQueueInterface;

    /**
     * @param int $entityId
     * @return EventQueueInterface
     * @throws Exception\NoSuchEntityException
     */
    public function getById(int $entityId): EventQueueInterface;

    /**
     * @param int $entityId
     * @return EventQueueInterface|null
     */
    public function findById(int $entityId): ?EventQueueInterface;

    /**
     * @param SearchCriteriaInterface $searchCriteria
     * @return SearchResultsInterface
     * @throws Exception\LocalizedException
     */
    public function getList(SearchCriteriaInterface $searchCriteria): SearchResultsInterface;

    /**
     * @param EventQueueInterface $eventQueue
     * @return bool
     * @throws Exception\CouldNotDeleteException
     */
    public function delete(EventQueueInterface $eventQueue): bool;

    /**
     * @param int $entityId
     * @return bool
     * @throws Exception\NoSuchEntityException
     * @throws Exception\CouldNotDeleteException
     */
    public function deleteById(int $entityId): bool;
}
