<?php

declare(strict_types=1);

namespace Amasty\FacebookPixelPro\Api\Data;

interface ServerSideSettingsInterface
{
    public const MAIN_TABLE = 'amasty_fbpixel_pixel_server_side_settings';

    public const ENTITY_ID = 'entity_id';
    public const IS_ACTIVE = 'is_active';
    public const TOKEN = 'token';
    public const TEST_EVENT_CODE = 'test_event_code';
    public const PIXEL_ENTITY_ID = 'pixel_entity_id';
    public const IS_CATEGORY_VIEW_ENABLED = 'is_category_view_enabled';
    public const IS_PRODUCT_VIEW_ENABLED = 'is_product_view_enabled';
    public const IS_INIT_CHECKOUT_ENABLED = 'is_initiate_checkout_enabled';
    public const IS_PURCHASE_ENABLED = 'is_purchase_enabled';
    public const IS_SEARCH_ENABLED = 'is_search_enabled';
    public const IS_ADD_TO_CART_ENABLED = 'is_add_to_cart_enabled';
    public const IS_ADD_TO_WISHLIST_ENABLED = 'is_add_to_wishlist_enabled';
    public const IS_REGISTRATION_ENABLED = 'is_registration_enabled';

    /**
     * @param int $entityId
     * @return ServerSideSettingsInterface
     */
    public function setId(int $entityId): ServerSideSettingsInterface;

    /**
     * @return int|null
     */
    public function getId(): ?int;

    /**
     * @param int $pixelEntityId
     * @return ServerSideSettingsInterface
     */
    public function setPixelEntityId(int $pixelEntityId): ServerSideSettingsInterface;

    /**
     * @return int|null
     */
    public function getPixelEntityId(): ?int;

    /**
     * @param string $token
     * @return ServerSideSettingsInterface
     */
    public function setToken(string $token): ServerSideSettingsInterface;

    /**
     * @return string|null
     */
    public function getToken(): ?string;

    /**
     * @param string $testEventCode
     * @return ServerSideSettingsInterface
     */
    public function setTestEventCode(string $testEventCode): ServerSideSettingsInterface;

    /**
     * @return string|null
     */
    public function getTestEventCode(): ?string;

    /**
     * @param bool $isEnabled
     * @return ServerSideSettingsInterface
     */
    public function setIsCategoryViewEnabled(bool $isEnabled): ServerSideSettingsInterface;

    /**
     * @return bool|null
     */
    public function getIsCategoryViewEnabled(): ?bool;

    /**
     * @param bool $isEnabled
     * @return ServerSideSettingsInterface
     */
    public function setIsProductViewEnabled(bool $isEnabled): ServerSideSettingsInterface;

    /**
     * @return bool|null
     */
    public function getIsProductViewEnabled(): ?bool;

    /**
     * @param bool $isEnabled
     * @return ServerSideSettingsInterface
     */
    public function setIsInitiateCheckoutEnabled(bool $isEnabled): ServerSideSettingsInterface;

    /**
     * @return bool|null
     */
    public function getIsInitiateCheckoutEnabled(): ?bool;

    /**
     * @param bool $isEnabled
     * @return ServerSideSettingsInterface
     */
    public function setIsPurchaseEnabled(bool $isEnabled): ServerSideSettingsInterface;

    /**
     * @return bool|null
     */
    public function getIsPurchaseEnabled(): ?bool;

    /**
     * @param bool $isEnabled
     * @return ServerSideSettingsInterface
     */
    public function setIsSearchEnabled(bool $isEnabled): ServerSideSettingsInterface;

    /**
     * @return bool|null
     */
    public function getIsSearchEnabled(): ?bool;

    /**
     * @param bool $isEnabled
     * @return ServerSideSettingsInterface
     */
    public function setIsAddToCartEnabled(bool $isEnabled): ServerSideSettingsInterface;

    /**
     * @return bool|null
     */
    public function getIsAddToCartEnabled(): ?bool;

    /**
     * @param bool $isEnabled
     * @return ServerSideSettingsInterface
     */
    public function setIsAddToWishlistEnabled(bool $isEnabled): ServerSideSettingsInterface;

    /**
     * @return bool|null
     */
    public function getIsAddToWishlistEnabled(): ?bool;

    /**
     * @param bool $isEnabled
     * @return ServerSideSettingsInterface
     */
    public function setIsRegistrationEnabled(bool $isEnabled): ServerSideSettingsInterface;

    /**
     * @return bool|null
     */
    public function getIsRegistrationEnabled(): ?bool;

    /**
     * @param bool $isActive
     * @return ServerSideSettingsInterface
     */
    public function setIsActive(bool $isActive): ServerSideSettingsInterface;

    /**
     * @return bool|null
     */
    public function getIsActive(): ?bool;
}
