<?php

declare(strict_types=1);

namespace Amasty\FacebookPixelPro\Api\Data;

interface EventQueueInterface
{
    public const MAIN_TABLE = 'amasty_fbpixel_pixel_server_side_queue';

    public const ENTITY_ID = 'entity_id';
    public const TOKEN = 'token';
    public const TEST_EVENT_CODE = 'test_event_code';
    public const PIXEL_ID = 'pixel_id';
    public const EVENT_DATA = 'event_data';

    /**
     * @param int $entityId
     * @return EventQueueInterface
     */
    public function setId(int $entityId): EventQueueInterface;

    /**
     * @return int|null
     */
    public function getId(): ?int;

    /**
     * @param string $pixelId
     * @return EventQueueInterface
     */
    public function setPixelId(string $pixelId): EventQueueInterface;

    /**
     * @return string|null
     */
    public function getPixelId(): ?string;

    /**
     * @param string $token
     * @return EventQueueInterface
     */
    public function setToken(string $token): EventQueueInterface;

    /**
     * @return string|null
     */
    public function getToken(): ?string;

    /**
     * @param string|null $testEventCode
     * @return EventQueueInterface
     */
    public function setTestEventCode(?string $testEventCode): EventQueueInterface;

    /**
     * @return string|null
     */
    public function getTestEventCode(): ?string;

    /**
     * @param string $eventData
     * @return EventQueueInterface
     */
    public function setEventData(string $eventData): EventQueueInterface;

    /**
     * @return string|null
     */
    public function getEventData(): ?string;
}
