/**
 * Facebook pixel actions
 * @api
 */

define([
    'jquery',
    'Amasty_FacebookPixel/js/model/amfb-model'
], function ($, amFbModel) {
    'use strict';

    /**
     * Call facebook actions with data
     * @param {Object|String} eventsData
     */
    function setFbqData(eventsData) {
        $.each(JSON.parse(eventsData), function (key, data) {
            var id = Object.keys(data)[0];

            if (id) {
                fbq(data[id].event_action, id, data[id].event_type, data[id].event_data, {eventID: data[id].event_id});
            }
        });

        logEventData(eventsData);
    }


    /**
     * @param {String} code
     * @param {String} url
     * @param {Object} eventsData
     * @returns {Deferred}
     */
    function setDataToSection(code, url, eventsData) {
        return $.ajax({
            url: url,
            data: {event_code: code, event_data: JSON.parse(eventsData)},
            type: 'post',
            dataType: 'json',
            showLoader: false,
        });
    }

    /**
     * Log facebook events with data
     * @param {Object|String} eventsData
     */
    function logEventData(eventsData) {
        var logUrl = amFbModel.getLogEventUrl();

        if (logUrl && amFbModel.isLogEnabled()) {
            $.ajax({
                url: logUrl,
                data: {events: JSON.parse(eventsData)},
                type: 'post',
                dataType: 'json',
                showLoader: false,
            });
        }
    }

    return {
        setFbqData: setFbqData,
        setDataToSection: setDataToSection
    }
});
