<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Facebook Pixel Base for Magento 2
 */

namespace Amasty\FacebookPixel\Ui\DataProvider\Form;

use Amasty\FacebookPixel\Api\Data\PixelInterface;
use Amasty\FacebookPixel\Api\PixelRepositoryInterface;
use Amasty\FacebookPixel\Model\ResourceModel\Pixel\Collection;
use Amasty\FacebookPixel\Model\ResourceModel\Pixel\CollectionFactory;
use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\View\Element\UiComponent\ContextInterface;
use Magento\Ui\DataProvider\AbstractDataProvider;
use Psr\Log\LoggerInterface;

class Pixel extends AbstractDataProvider
{
    /**
     * @var CollectionFactory
     */
    private $collectionFactory;

    /**
     * @var PixelRepositoryInterface
     */
    private $pixelRepository;

    /**
     * @var ContextInterface
     */
    private $context;

    /**
     * @var LoggerInterface
     */
    private $logger;

    /**
     * @var array
     */
    private $loadedData = [];

    public function __construct(
        string $name,
        string $primaryFieldName,
        string $requestFieldName,
        PixelRepositoryInterface $pixelRepository,
        CollectionFactory $collectionFactory,
        ContextInterface $context,
        LoggerInterface $logger,
        array $meta = [],
        array $data = []
    ) {
        $this->pixelRepository = $pixelRepository;
        $this->collectionFactory = $collectionFactory;
        $this->context = $context;
        $this->logger = $logger;
        parent::__construct($name, $primaryFieldName, $requestFieldName, $meta, $data);
    }

    /**
     * @return array
     */
    public function getData(): array
    {
        if (empty($this->loadedData)) {
            $entityId = (int)$this->context->getRequestParam('id');
            try {
                /** @var PixelInterface $banner */
                $pixel = $this->pixelRepository->getById($entityId);
                $extensionAttributes = [];

                foreach ($pixel->getExtensionAttributes()->__toArray() as $key => $extensionAttribute) {
                    if (is_object($extensionAttribute)) {
                        $extensionAttributes[$key] = $extensionAttribute->toArray();
                        continue;
                    }

                    $extensionAttributes[$key] = $extensionAttribute;
                }

                $pixelData = $pixel->toArray();
                $pixelData['extension_attributes'] = $extensionAttributes;

                $this->loadedData[$pixel->getId()] = $pixelData;
            } catch (LocalizedException $e) {
                $this->logger->critical($e);
            }
        }

        return $this->loadedData;
    }

    /**
     * @return Collection
     */
    public function getCollection(): Collection
    {
        if ($this->collection === null) {
            $this->collection = $this->collectionFactory->create();
        }

        return $this->collection;
    }
}
