<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Facebook Pixel Base for Magento 2
 */
/**
 * @codingStandardsIgnoreFile
 */
namespace Amasty\FacebookPixel\Test\Unit\Model;

use Amasty\FacebookPixel\Test\Unit\Traits;
use Amasty\FacebookPixel\Model\Pixel;
use PHPUnit\Framework\TestCase;

class PixelTest extends TestCase
{
    use Traits\ObjectManagerTrait;
    use Traits\ReflectionTrait;

    /**
     * @covers \Amasty\FacebookPixel\Model\Pixel::getStores
     *
     * @dataProvider getStoresDataProvider
     */
    public function testGetStores($inputParams, $expectedResult)
    {
        $model = $this->getObjectManager()->getObject(Pixel::class);

        $model->setStores($inputParams);
        $this->assertEquals($expectedResult, $model->getStores());
    }

    /**
     * @return array
     */
    public function getStoresDataProvider()
    {
        return [
            [
                '1,2,3,4,5,6',
                [1,2,3,4,5,6]
            ],
            [
                [1,2,3,4],
                [1,2,3,4]
            ],
            [
                1,
                [1]
            ],
            [
                '0',
                [0]
            ]
        ];
    }
}
