<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Facebook Pixel Base for Magento 2
 */
/**
 * @codingStandardsIgnoreFile
 */
namespace Amasty\FacebookPixel\Test\Unit\Model;

use Amasty\FacebookPixel\Test\Unit\Traits;
use Amasty\FacebookPixel\Model\PageViewEventResolver;
use Magento\Framework\App\Request\Http;
use PHPUnit\Framework\TestCase;

class PageViewEventResolverTest extends TestCase
{
    use Traits\ObjectManagerTrait;
    use Traits\ReflectionTrait;

    /**
     * @covers \Amasty\FacebookPixel\Model\PageViewEventResolver::getEventKey
     *
     * @dataProvider eventKeyDataProvider
     */
    public function testGetEventKey($events, $eventsKeyToCheck, $expectedResult)
    {
        /** @var \Amasty\FacebookPixel\Model\PageViewEventResolver  $model */
        $model = $this->getObjectManager()->getObject(PageViewEventResolver::class);

        foreach ($eventsKeyToCheck as $key => $eventKey) {
            $request = $this->getMockBuilder(Http::class)
                ->disableOriginalConstructor()
                ->setMethods(['getFullActionName'])
                ->getMock();
            $request->expects($this->any())->method('getFullActionName')->willReturn($eventKey);
            $this->setProperty($model, 'request', $request, PageViewEventResolver::class);
            $this->setProperty($model, 'events', $events, PageViewEventResolver::class);
            $this->assertEquals($expectedResult[$key], $model->getEventKey());
        }
    }

    /**
     * @return array
     */
    public function eventKeyDataProvider()
    {
        return [
            [
                [
                    'test1_action' => 'test1_event',
                    'test2_action' => 'test2_event',
                ],
                [
                    'test1_action',
                    'test2_action',
                    'test3_action'
                ],
                [
                    'test1_event',
                    'test2_event',
                    null
                ]
            ]
        ];
    }
}
