<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Facebook Pixel Base for Magento 2
 */
/**
 * @codingStandardsIgnoreFile
 */
namespace Amasty\FacebookPixel\Test\Unit\Model;

use Amasty\FacebookPixel\Test\Unit\Traits;
use Amasty\FacebookPixel\Model\EventIdProvider;
use Magento\Framework\FlagManager;
use PHPUnit\Framework\TestCase;

class EventIdProviderTest extends TestCase
{
    use Traits\ObjectManagerTrait;
    use Traits\ReflectionTrait;

    /**
     * @covers \Amasty\FacebookPixel\Model\EventIdProvider::getNewEventId
     *
     * @dataProvider newEventIdDataProvider
     */
    public function testGetNewEventId($lastEventId, $expectedResult)
    {
        $model = $this->getObjectManager()->getObject(EventIdProvider::class);

        $flagManager = $this->getMockBuilder(FlagManager::class)
            ->disableOriginalConstructor()
            ->setMethods(['getFlagData', 'saveFlag'])
            ->getMock();

        $flagManager->expects($this->any())->method('getFlagData')->willReturn($lastEventId);
        $flagManager->expects($this->any())->method('saveFlag')->willReturn(true);
        $this->setProperty($model, 'flagManager', $flagManager, EventIdProvider::class);
        $this->assertEquals($expectedResult, $model->getNewEventId());
    }

    /**
     * @return array
     */
    public function newEventIdDataProvider()
    {
        return [
            [100, 101],
            [999, 1000],
            [100000, 100001],
        ];
    }
}
