<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Facebook Pixel Base for Magento 2
 */
/**
 * @codingStandardsIgnoreFile
 */
namespace Amasty\FacebookPixel\Test\Unit\Model\Api;

use Amasty\FacebookPixel\Model\EventData\EventDataGeneratorPool;
use Amasty\FacebookPixel\Test\Unit\Traits;
use Magento\Framework\Exception\LocalizedException;
use PHPUnit\Framework\TestCase;

class EventDataGeneratorPoolTest extends TestCase
{
    use Traits\ObjectManagerTrait;
    use Traits\ReflectionTrait;

    /**
     * @covers \Amasty\FacebookPixel\Model\EventData\EventDataGeneratorPool::initDataGenerator
     */
    public function testInitDataGenerator()
    {
        $generatorPool = $this->getObjectManager()->getObject(EventDataGeneratorPool::class);
        $this->setProperty($generatorPool, 'eventDataGenerators', []);

        $this->expectException(LocalizedException::class);
        $this->expectExceptionMessage('Event Data Generator with test_event_code code is not declared');

        $this->invokeMethod($generatorPool, 'initDataGenerator', ['test_event_code']);
    }
}
