<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Facebook Pixel Base for Magento 2
 */
/**
 * @codingStandardsIgnoreFile
 */

namespace Amasty\FacebookPixel\Test\Unit\Model;

use Amasty\FacebookPixel\Model\EventData\EventDataGenerator\Search;
use Amasty\FacebookPixel\Test\Unit\Traits;
use Magento\CatalogSearch\Helper\Data;
use PHPUnit\Framework\TestCase;

class SearchTest extends TestCase
{
    use Traits\ObjectManagerTrait;
    use Traits\ReflectionTrait;

    /**
     * @covers \Amasty\FacebookPixel\Model\EventData\EventDataGenerator\Search::getEventData
     *
     * @dataProvider searchEventDataProvider
     */
    public function testGetNewEventId($searchStringParam, $searchFromHelper, $expectedResult)
    {
        $model = $this->getObjectManager()->getObject(Search::class);

        $searchHelper = $this->getMockBuilder(Data::class)
            ->disableOriginalConstructor()
            ->setMethods(['getEscapedQueryText'])
            ->getMock();

        $searchHelper->expects($this->any())->method('getEscapedQueryText')->willReturn($searchFromHelper);
        $this->setProperty($model, 'catalogSearch', $searchHelper, Search::class);
        $this->assertEquals($expectedResult, $model->getEventData($searchStringParam));
    }

    /**
     * @return array
     */
    public function searchEventDataProvider()
    {
        return [
            [
                'testSearch',
                null,
                ['search_string' => 'testSearch',]
            ],
            [
                null,
                'testSearch',
                ['search_string' => 'testSearch',]
            ],
        ];
    }
}
