<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Facebook Pixel Base for Magento 2
 */
/**
 * @codingStandardsIgnoreFile
 */

namespace Amasty\FacebookPixel\Test\Unit\Model;

use Amasty\FacebookPixel\Model\EventData\EventDataGenerator\Registration;
use Amasty\FacebookPixel\Test\Unit\Traits;
use Magento\Store\Model\Store;
use PHPUnit\Framework\TestCase;

class RegistrationTest extends TestCase
{
    use Traits\ObjectManagerTrait;
    use Traits\ReflectionTrait;

    /**
     * @covers \Amasty\FacebookPixel\Model\EventData\EventDataGenerator\Registration::getEventData
     */
    public function testGetNewEventId()
    {
        $model = $this->getObjectManager()->getObject(Registration::class);

        $store = $this->getMockBuilder(Store::class)
            ->disableOriginalConstructor()
            ->setMethods(['getCurrentCurrencyCode'])
            ->getMock();

        $store->expects($this->any())->method('getCurrentCurrencyCode')->willReturn('USD');
        $this->setProperty($model, 'store', $store, Registration::class);

        $result = $model->getEventData();
        $this->assertArrayHasKey('currency', $result);
        $this->assertTrue($result['success']);
    }

    /**
     * @return array
     */
    public function searchEventDataProvider()
    {
        return [
            [
                'testSearch',
                null,
                ['search_string' => 'testSearch',]
            ],
            [
                null,
                'testSearch',
                ['search_string' => 'testSearch',]
            ],
        ];
    }
}
