<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Facebook Pixel Base for Magento 2
 */
/**
 * @codingStandardsIgnoreFile
 */
namespace Amasty\FacebookPixel\Test\Unit\CustomerData;

use Amasty\FacebookPixel\Test\Unit\Traits;
use Amasty\FacebookPixel\CustomerData\EventData;
use Amasty\FacebookPixel\Model\EventSession;
use PHPUnit\Framework\TestCase;

class EventDataTest extends TestCase
{
    use Traits\ObjectManagerTrait;
    use Traits\ReflectionTrait;

    /**
     * @covers \Amasty\FacebookPixel\CustomerData\EventData::getSectionData
     *
     * @dataProvider sectionDataDataProvider
     */
    public function testGetNewEventId($inputParams, $expectedResult)
    {
        $model = $this->getObjectManager()->getObject(EventData::class);

        $eventSession = $this->getMockBuilder(EventSession::class)
            ->disableOriginalConstructor()
            ->setMethods(['getEvents'])
            ->getMock();

        $eventSession->expects($this->any())->method('getEvents')->willReturn($inputParams);
        $this->setProperty($model, 'eventSession', $eventSession, EventData::class);
        $this->assertEquals($expectedResult, $model->getSectionData());
    }

    /**
     * @return array
     */
    public function sectionDataDataProvider()
    {
        return [
            [
                ['test_event_data'], ['events' => ['test_event_data']]
            ],
            [
                ['test_array' => [1, 2, 3, 4]], ['events' => ['test_array' => [1, 2, 3, 4]]]
            ],
        ];
    }
}
