<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Facebook Pixel Base for Magento 2
 */

namespace Amasty\FacebookPixel\Observer;

use Amasty\FacebookPixel\Model\EventProcessor;
use Magento\Framework\Event\Observer;
use Magento\Framework\Event\ObserverInterface;
use Psr\Log\LoggerInterface;

class AddToWishlistEvent implements ObserverInterface
{
    /**
     * @var LoggerInterface
     */
    private $logger;

    /**
     * @var EventProcessor
     */
    private $eventProcessor;

    public function __construct(
        EventProcessor $eventProcessor,
        LoggerInterface $logger
    ) {
        $this->logger = $logger;
        $this->eventProcessor = $eventProcessor;
    }

    /**
     * @param Observer $observer
     * @return void
     */
    public function execute(Observer $observer): void
    {
        $items = $observer->getData('items');
        foreach ($items as $item) {
            $wishlistItem = $item;
            break;
        }

        if (!empty($wishlistItem)) {
            try {
                $this->eventProcessor->processEvent('addToWishList', $wishlistItem);
            } catch (\Exception $e) {
                $this->logger->critical($e);
            }
        }
    }
}
