<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Facebook Pixel Base for Magento 2
 */

namespace Amasty\FacebookPixel\Observer;

use Amasty\FacebookPixel\Model\EventProcessor;
use Magento\Framework\Event\Observer;
use Magento\Framework\Event\ObserverInterface;
use Magento\Quote\Model\Quote\Item;
use Psr\Log\LoggerInterface;

class AddToCartEvent implements ObserverInterface
{
    /**
     * @var LoggerInterface
     */
    private $logger;

    /**
     * @var EventProcessor
     */
    private $eventProcessor;

    public function __construct(
        EventProcessor $eventProcessor,
        LoggerInterface $logger
    ) {
        $this->logger = $logger;
        $this->eventProcessor = $eventProcessor;
    }

    /**
     * @param Observer $observer
     * @return void
     */
    public function execute(Observer $observer): void
    {
        /** @var Item[] $item */
        $items = $observer->getData('items');
        if ($items) {
            try {
                $this->eventProcessor->processEvent('addToCart', $items);
            } catch (\Exception $e) {
                $this->logger->critical($e);
            }
        }
    }
}
