<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Facebook Pixel Base for Magento 2
 */

namespace Amasty\FacebookPixel\Model\ThirdParty;

use Magento\Framework\Module\Manager;

class ModuleChecker
{
    /**
     * @var Manager
     */
    private $moduleManager;

    public function __construct(Manager $moduleManager)
    {
        $this->moduleManager = $moduleManager;
    }

    public function isAmastyGdprCookieEnabled(): bool
    {
        return $this->moduleManager->isEnabled('Amasty_GdprCookie');
    }

    public function isAmastyGdprCookieFacebookPixelSampleDataEnabled(): bool
    {
        return $this->moduleManager->isEnabled('Amasty_GdprCookieFacebookPixelSampleData');
    }
}
