<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Facebook Pixel Base for Magento 2
 */

namespace Amasty\FacebookPixel\Model;

use Amasty\FacebookPixel\Api\Data\PixelInterface;
use Amasty\FacebookPixel\Api\PixelRepositoryInterface;
use Magento\Store\Model\StoreManagerInterface;
use Magento\Framework\Api\SearchCriteriaBuilderFactory;
use Psr\Log\LoggerInterface;

class PixelProvider
{
    /**
     * @var PixelRepositoryInterface
     */
    private $pixelRepository;

    /**
     * @var SearchCriteriaBuilderFactory
     */
    private $searchCriteriaBuilderFactory;

    /**
     * @var StoreManagerInterface
     */
    private $storeManager;

    /**
     * @var LoggerInterface
     */
    private $logger;

    public function __construct(
        PixelRepositoryInterface $pixelRepository,
        SearchCriteriaBuilderFactory $searchCriteriaBuilderFactory,
        StoreManagerInterface $storeManager,
        LoggerInterface $logger
    ) {
        $this->pixelRepository = $pixelRepository;
        $this->searchCriteriaBuilderFactory = $searchCriteriaBuilderFactory;
        $this->storeManager = $storeManager;
        $this->logger = $logger;
    }

    /**
     * @return array
     */
    public function getEnabledPixelsForCurrentStore(): array
    {
        $searchCriteria = $this->searchCriteriaBuilderFactory->create()
            ->addFilter(PixelInterface::IS_ACTIVE, 1)
            ->addFilter(
                PixelInterface::STORE_ID_FIELD,
                [0, $this->storeManager->getStore()->getId()],
                'in'
            )->create();

        try {
            return $this->pixelRepository->getList($searchCriteria)->getItems();
        } catch (\Exception $e) {
            $this->logger->critical($e);

            return [];
        }
    }
}
