<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Facebook Pixel Base for Magento 2
 */

namespace Amasty\FacebookPixel\Model;

use Amasty\FacebookPixel\Api\Data\PixelExtensionInterface;
use Amasty\FacebookPixel\Api\Data\PixelInterface;
use Magento\Framework\Api\ExtensionAttributesInterface;
use Magento\Framework\Model\AbstractExtensibleModel;

class Pixel extends AbstractExtensibleModel implements PixelInterface
{
    /**
     * @inheritdoc
     */
    protected function _construct()
    {
        $this->_init(ResourceModel\Pixel::class);
    }

    /**
     * @param int $entityId
     * @return PixelInterface
     */
    public function setId($entityId): PixelInterface
    {
        return $this->setData(self::ENTITY_ID, $entityId);
    }

    /**
     * @return int|null
     */
    public function getId(): ?int
    {
        return $this->getData(self::ENTITY_ID) !== null
            ? (int)$this->getData(self::ENTITY_ID) : null;
    }

    /**
     * @param string $pixelId
     * @return PixelInterface
     */
    public function setPixelId(string $pixelId): PixelInterface
    {
        return $this->setData(self::PIXEL_ID, $pixelId);
    }

    /**
     * @return string|null
     */
    public function getPixelId(): ?string
    {
        return $this->getData(self::PIXEL_ID) ?? null;
    }

    /**
     * @param bool $isEnabled
     * @return PixelInterface
     */
    public function setIsCategoryViewEnabled(bool $isEnabled): PixelInterface
    {
        return $this->setData(self::IS_CATEGORY_VIEW_ENABLED, $isEnabled);
    }

    /**
     * @return bool|null
     */
    public function getIsCategoryViewEnabled(): ?bool
    {
        return $this->getData(self::IS_CATEGORY_VIEW_ENABLED) !== null
            ? (bool)$this->getData(self::IS_CATEGORY_VIEW_ENABLED) : null;
    }

    /**
     * @param bool $isEnabled
     * @return PixelInterface
     */
    public function setIsProductViewEnabled(bool $isEnabled): PixelInterface
    {
        return $this->setData(self::IS_PRODUCT_VIEW_ENABLED, $isEnabled);
    }

    /**
     * @return bool|null
     */
    public function getIsProductViewEnabled(): ?bool
    {
        return $this->getData(self::IS_PRODUCT_VIEW_ENABLED) !== null
            ? (bool)$this->getData(self::IS_PRODUCT_VIEW_ENABLED) : null;
    }

    /**
     * @param bool $isEnabled
     * @return PixelInterface
     */
    public function setIsInitiateCheckoutEnabled(bool $isEnabled): PixelInterface
    {
        return $this->setData(self::IS_INIT_CHECKOUT_ENABLED, $isEnabled);
    }

    /**
     * @return bool|null
     */
    public function getIsInitiateCheckoutEnabled(): ?bool
    {
        return $this->getData(self::IS_INIT_CHECKOUT_ENABLED) !== null
            ? (bool)$this->getData(self::IS_INIT_CHECKOUT_ENABLED) : null;
    }

    /**
     * @param bool $isEnabled
     * @return PixelInterface
     */
    public function setIsPurchaseEnabled(bool $isEnabled): PixelInterface
    {
        return $this->setData(self::IS_PURCHASE_ENABLED, $isEnabled);
    }

    /**
     * @return bool|null
     */
    public function getIsPurchaseEnabled(): ?bool
    {
        return $this->getData(self::IS_PURCHASE_ENABLED) !== null
            ? (bool)$this->getData(self::IS_PURCHASE_ENABLED) : null;
    }

    /**
     * @param bool $isEnabled
     * @return PixelInterface
     */
    public function setIsSearchEnabled(bool $isEnabled): PixelInterface
    {
        return $this->setData(self::IS_SEARCH_ENABLED, $isEnabled);
    }

    /**
     * @return bool|null
     */
    public function getIsSearchEnabled(): ?bool
    {
        return $this->getData(self::IS_SEARCH_ENABLED) !== null
            ? (bool)$this->getData(self::IS_SEARCH_ENABLED) : null;
    }

    /**
     * @param bool $isEnabled
     * @return PixelInterface
     */
    public function setIsAddToCartEnabled(bool $isEnabled): PixelInterface
    {
        return $this->setData(self::IS_ADD_TO_CART_ENABLED, $isEnabled);
    }

    /**
     * @return bool|null
     */
    public function getIsAddToCartEnabled(): ?bool
    {
        return $this->getData(self::IS_ADD_TO_CART_ENABLED) !== null
            ? (bool)$this->getData(self::IS_ADD_TO_CART_ENABLED) : null;
    }

    /**
     * @param bool $isEnabled
     * @return PixelInterface
     */
    public function setIsAddToWishlistEnabled(bool $isEnabled): PixelInterface
    {
        return $this->setData(self::IS_ADD_TO_WISHLIST_ENABLED, $isEnabled);
    }

    /**
     * @return bool|null
     */
    public function getIsAddToWishlistEnabled(): ?bool
    {
        return $this->getData(self::IS_ADD_TO_WISHLIST_ENABLED) !== null
            ? (bool)$this->getData(self::IS_ADD_TO_WISHLIST_ENABLED) : null;
    }

    /**
     * @param bool $isEnabled
     * @return PixelInterface
     */
    public function setIsRegistrationEnabled(bool $isEnabled): PixelInterface
    {
        return $this->setData(self::IS_REGISTRATION_ENABLED, $isEnabled);
    }

    /**
     * @return bool|null
     */
    public function getIsRegistrationEnabled(): ?bool
    {
        return $this->getData(self::IS_REGISTRATION_ENABLED) !== null
            ? (bool)$this->getData(self::IS_REGISTRATION_ENABLED) : null;
    }

    /**
     * @param bool $isEnabled
     * @return PixelInterface
     */
    public function setIsActive(bool $isActive): PixelInterface
    {
        return $this->setData(self::IS_ACTIVE, $isActive);
    }

    /**
     * @return bool|null
     */
    public function getIsActive(): ?bool
    {
        return $this->getData(self::IS_ACTIVE) !== null
            ? (bool)$this->getData(self::IS_ACTIVE) : null;
    }

    /**
     * Get Stores
     * @return array|null
     */
    public function getStores(): ?array
    {
        if ($this->getData(self::STORES) === null) {
            return null;
        }

        return is_array($this->getData(self::STORES))
            ? $this->getData(self::STORES)
            : explode(',', (string)$this->getData(self::STORES));
    }

    /**
     * @param mixed $stores
     * @return PixelInterface
     */
    public function setStores($stores): PixelInterface
    {
        return $this->setData(self::STORES, $stores);
    }

    /**
     * Retrieve existing extension attributes object or create a new one.
     * @return PixelExtensionInterface|null
     */
    public function getExtensionAttributes(): ExtensionAttributesInterface
    {
        return $this->_getExtensionAttributes();
    }

    /**
     * Set an extension attributes object.
     * @param PixelExtensionInterface $extensionAttributes
     * @return $this
     */
    public function setExtensionAttributes(
        PixelExtensionInterface $extensionAttributes
    ) {
        return $this->_setExtensionAttributes($extensionAttributes);
    }
}
