<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Facebook Pixel Base for Magento 2
 */

namespace Amasty\FacebookPixel\Model;

use Magento\Framework\Session\SessionManager;

class EventSession extends SessionManager
{
    /**
     * @param array data
     * @return $this
     */
    public function setEvents(array $data): EventSession
    {
        if (!$eventsData = $this->getEvents(false)) {
            $eventsData = [];
        }

        $eventsData = array_merge($eventsData, $data);
        $this->setData('events', $eventsData);

        return $this;
    }

    /**
     * @param bool $clear
     * @return array|null
     */
    public function getEvents(bool $clear = true): ?array
    {
        return $this->getData('events', $clear);
    }
}
