<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Facebook Pixel Base for Magento 2
 */

namespace Amasty\FacebookPixel\Model;

use Magento\Framework\FlagManager;

class EventIdProvider
{
    const EVENT_ID_START = 1000000;
    const FLAG_CODE = 'am_fbpixel_last_event_id';

    /**
     * @var FlagManager
     */
    private $flagManager;

    public function __construct(
        FlagManager $flagManager
    ) {
        $this->flagManager = $flagManager;
    }

    /**
     * @return int
     */
    public function getNewEventId(): int
    {
        $eventId = $this->getLastEventId();
        if (!$eventId) {
            $this->saveNewEventId(self::EVENT_ID_START);

            return self::EVENT_ID_START;
        }

        $eventId++;
        $this->saveNewEventId($eventId);

        return (int)$eventId;
    }

    /**
     * @param int $eventId
     */
    private function saveNewEventId(int $eventId): void
    {
        $this->flagManager->saveFlag(self::FLAG_CODE, $eventId);
    }

    /**
     * @return int|null
     */
    private function getLastEventId(): ?int
    {
        return $this->flagManager->getFlagData(self::FLAG_CODE);
    }
}
