<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Facebook Pixel Base for Magento 2
 */

namespace Amasty\FacebookPixel\Model\EventData\EventDataGenerator;

use Amasty\FacebookPixel\Api\Data\PixelInterface;
use Magento\CatalogSearch\Helper\Data;

class Search implements EventDataGeneratorInterface
{
    private const EVENT_ACTION = 'trackSingle';
    private const EVENT_TYPE = 'Search';

    /**
     * @var Data
     */
    private $catalogSearch;

    public function __construct(
        Data $catalogSearch
    ) {
        $this->catalogSearch = $catalogSearch;
    }

    /**
     * @param null|string $searchString
     * @return array|null
     */
    public function getEventData($searchString = null): ?array
    {
        $searchString = $searchString ?? $this->getSearchString();
        if ($searchString === null) {
            return null;
        }

        return [
            'search_string' => $searchString,
        ];
    }

    /**
     * @return string
     */
    public function getEventAction(): string
    {
        return self::EVENT_ACTION;
    }

    /**
     * @return string
     */
    public function getEventType(): string
    {
        return self::EVENT_TYPE;
    }

    /**
     * @param PixelInterface $pixel
     * @return bool
     */
    public function isEventEnabledForPixel(PixelInterface $pixel): bool
    {
        return $pixel->getIsSearchEnabled();
    }

    /**
     * @return string|null
     */
    private function getSearchString(): ?string
    {
        return $this->catalogSearch->getEscapedQueryText();
    }
}
