<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Facebook Pixel Base for Magento 2
 */

namespace Amasty\FacebookPixel\Model\EventData\EventDataGenerator;

use Amasty\FacebookPixel\Api\Data\PixelInterface;
use Magento\Store\Api\Data\StoreInterface;

class Registration implements EventDataGeneratorInterface
{
    private const EVENT_ACTION = 'trackSingle';
    private const EVENT_TYPE = 'CompleteRegistration';

    /**
     * @var StoreInterface
     */
    private $store;

    public function __construct(
        StoreInterface $store
    ) {
        $this->store = $store;
    }

    /**
     * @param null $eventObject
     * @return array|null
     */
    public function getEventData($eventObject = null): ?array
    {
        return [
            'success' => true,
            'value' => 0,
            'currency' => $this->store->getCurrentCurrencyCode()
        ];
    }

    /**
     * @param PixelInterface $pixel
     * @return bool
     */
    public function isEventEnabledForPixel(PixelInterface $pixel): bool
    {
        return $pixel->getIsRegistrationEnabled();
    }

    /**
     * @return string
     */
    public function getEventAction(): string
    {
        return self::EVENT_ACTION;
    }

    /**
     * @return string
     */
    public function getEventType(): string
    {
        return self::EVENT_TYPE;
    }
}
