<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Facebook Pixel Base for Magento 2
 */

namespace Amasty\FacebookPixel\Model\EventData\EventDataGenerator;

use Amasty\FacebookPixel\Api\Data\PixelInterface;

interface EventDataGeneratorInterface
{
    /**
     * @param null $eventObject
     * @return array|null
     */
    public function getEventData($eventObject = null): ?array;

    /**
     * @return string
     */
    public function getEventAction(): string;

    /**
     * @return string
     */
    public function getEventType(): string;

    /**
     * @param PixelInterface $pixel
     * @return bool
     */
    public function isEventEnabledForPixel(PixelInterface $pixel): bool;
}
