<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Facebook Pixel Base for Magento 2
 */

namespace Amasty\FacebookPixel\Model\EventData\EventDataGenerator;

use Amasty\FacebookPixel\Api\Data\PixelInterface;
use Magento\Catalog\Api\Data\CategoryInterface;
use Magento\Framework\Registry;
use Magento\Store\Api\Data\StoreInterface;

class CategoryView implements EventDataGeneratorInterface
{
    private const EVENT_ACTION = 'trackSingleCustom';
    private const EVENT_TYPE = 'ViewCategory';

    /**
     * @var Registry
     */
    private $registry;

    /**
     * @var StoreInterface
     */
    private $store;

    public function __construct(
        Registry $registry,
        StoreInterface $store
    ) {
        $this->registry = $registry;
        $this->store = $store;
    }

    /**
     * @param null|CategoryInterface $category
     * @return array|null
     */
    public function getEventData($category = null): ?array
    {
        $category = $category ?? $this->getCurrentCategory();
        if ($category === null) {
            return null;
        }

        $eventData = [
            'content_name' => $category->getName(),
            'content_ids' => [$category->getId()],
            'content_type' => 'product_group',
            'value' => 0,
            'currency' => $this->store->getCurrentCurrencyCode()
        ];

        return $eventData;
    }

    /**
     * @return string
     */
    public function getEventAction(): string
    {
        return self::EVENT_ACTION;
    }

    /**
     * @return string
     */
    public function getEventType(): string
    {
        return self::EVENT_TYPE;
    }

    /**
     * @param PixelInterface $pixel
     * @return bool
     */
    public function isEventEnabledForPixel(PixelInterface $pixel): bool
    {
        return $pixel->getIsCategoryViewEnabled();
    }

    /**
     * @return CategoryInterface|null
     */
    private function getCurrentCategory(): ?CategoryInterface
    {
        return $this->registry->registry('current_category');
    }
}
