<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Facebook Pixel Base for Magento 2
 */

namespace Amasty\FacebookPixel\Model\EventData\EventDataGenerator;

use Amasty\FacebookPixel\Api\Data\PixelInterface;
use Magento\Store\Api\Data\StoreInterface;
use Magento\Wishlist\Model\Item;

class AddToWishlist implements EventDataGeneratorInterface
{
    private const EVENT_ACTION = 'trackSingle';
    private const EVENT_TYPE = 'AddToWishlist';

    /**
     * @var StoreInterface
     */
    private $store;

    public function __construct(
        StoreInterface $store
    ) {
        $this->store = $store;
    }

    /**
     * @param null|Item $item
     * @return array|null
     */
    public function getEventData($item = null): ?array
    {
        if ($item === null) {
            return null;
        }

        $contents = [
            'id' => $item->getProduct()->getSku(),
        ];
        if ($item->getQty()) {
            $contents['quantity'] = $item->getQty();
        }

        return [
            'content_name' => $item->getProduct()->getName(),
            'content_ids' => [$item->getProduct()->getSku()],
            'content_type' => 'product',
            'contents' => [$contents],
            'currency' => $this->store->getCurrentCurrencyCode(),
            'value' => 0
        ];
    }

    /**
     * @param PixelInterface $pixel
     * @return bool
     */
    public function isEventEnabledForPixel(PixelInterface $pixel): bool
    {
        return $pixel->getIsAddToWishlistEnabled();
    }

    /**
     * @return string
     */
    public function getEventAction(): string
    {
        return self::EVENT_ACTION;
    }

    /**
     * @return string
     */
    public function getEventType(): string
    {
        return self::EVENT_TYPE;
    }
}
