<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Facebook Pixel Base for Magento 2
 */

namespace Amasty\FacebookPixel\Model;

use Amasty\Base\Model\ConfigProviderAbstract;

class ConfigProvider extends ConfigProviderAbstract
{
    /**
     * xpath prefix of module (section)
     */
    protected $pathPrefix = 'amasty_facebook_pixel/';

    const GENERAL_BLOCK = 'general/';

    const PIXEL_ENABLED = 'is_enabled';
    const LOGGING_ENABLED = 'is_logging_enabled';

    /**
     * @return bool
     */
    public function isFacebookPixelEnabled(): bool
    {
        return $this->isSetFlag(self::GENERAL_BLOCK . self::PIXEL_ENABLED);
    }

    /**
     * @return bool
     */
    public function isLoggingEnabled(): bool
    {
        return $this->isSetFlag(self::GENERAL_BLOCK . self::LOGGING_ENABLED);
    }
}
