<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Facebook Pixel Base for Magento 2
 */

namespace Amasty\FacebookPixel\CustomerData;

use Amasty\FacebookPixel\Model\EventSession;
use Magento\Customer\CustomerData\SectionSourceInterface;
use Magento\Framework\Serialize\SerializerInterface;

class EventData implements SectionSourceInterface
{
    /**
     * @var EventSession
     */
    private $eventSession;

    public function __construct(
        EventSession $eventSession,
        SerializerInterface $serializer = null // @deprecated. Backward compatibility
    ) {
        $this->eventSession = $eventSession;
    }

    /**
     * @return array
     */
    public function getSectionData(): array
    {
        $eventsData = $this->eventSession->getEvents();

        return $eventsData ? ['events' => $eventsData] : [];
    }
}
