<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Facebook Pixel Base for Magento 2
 */

namespace Amasty\FacebookPixel\Controller\PageView;

use Amasty\FacebookPixel\Model\EventProcessor;
use Magento\Framework\App\Action\HttpPostActionInterface;
use Magento\Framework\App\RequestInterface;
use Magento\Framework\Controller\Result\Json;
use Magento\Framework\Controller\ResultFactory;
use Magento\Framework\Controller\ResultInterface;
use Psr\Log\LoggerInterface;

class ProcessPageView implements HttpPostActionInterface
{
    private const EVENT_CODE_PARAM = 'event_code';
    private const EVENT_DATA_PARAM = 'event_data';

    /**
     * @var EventProcessor
     */
    private $eventProcessor;

    /**
     * @var RequestInterface
     */
    private $request;

    /**
     * @var ResultFactory
     */
    private $resultFactory;
    /**
     * @var LoggerInterface
     */
    private $logger;

    public function __construct(
        EventProcessor $eventProcessor,
        RequestInterface $request,
        ResultFactory $resultFactory,
        LoggerInterface $logger
    ) {
        $this->eventProcessor = $eventProcessor;
        $this->request = $request;
        $this->resultFactory = $resultFactory;
        $this->logger = $logger;
    }

    public function execute(): ResultInterface
    {
        $eventCode = $this->request->getParam(self::EVENT_CODE_PARAM);
        $eventData = $this->request->getParam(self::EVENT_DATA_PARAM);

        /** @var Json $resultJson */
        $resultJson = $this->resultFactory->create(ResultFactory::TYPE_JSON);
        $resultJson->setHttpResponseCode(200);
        $resultJson->setData([]);

        if (!$eventData || !$eventCode) {
            return $resultJson;
        }

        try {
            $this->eventProcessor->processEvent($eventCode, null, $eventData);
        } catch (\Exception $e) {
            $this->logger->critical($e);
        }

        return $resultJson;
    }
}
