<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Facebook Pixel Base for Magento 2
 */

namespace Amasty\FacebookPixel\Controller\Adminhtml\Pixels;

use Amasty\FacebookPixel\Api\PixelRepositoryInterface;
use Magento\Backend\App\Action;
use Magento\Backend\App\Action\Context;
use Magento\Framework\Controller\ResultInterface;
use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Framework\View\Result\PageFactory;

class Edit extends Action
{
    const ADMIN_RESOURCE = 'Amasty_FacebookPixel::manage_pixels';

    /**
     * @var PixelRepositoryInterface
     */
    private $pixelRepository;

    /**
     * @var PageFactory
     */
    private $resultPageFactory;

    /**
     * @param Context $context
     * @param PixelRepositoryInterface $pixelRepository
     * @param PageFactory $resultPageFactory
     */
    public function __construct(
        Context $context,
        PixelRepositoryInterface $pixelRepository,
        PageFactory $resultPageFactory
    ) {
        parent::__construct($context);
        $this->pixelRepository = $pixelRepository;
        $this->resultPageFactory = $resultPageFactory;
    }

    /**
     * @return ResultInterface
     */
    public function execute(): ResultInterface
    {
        $id = $this->getRequest()->getParam('id');

        if ($id) {
            try {
                $model = $this->pixelRepository->getById((int)$id);
            } catch (NoSuchEntityException $e) {
                $this->messageManager->addErrorMessage(__('This Pixel no longer exists.'));
                $resultRedirect = $this->resultRedirectFactory->create();

                return $resultRedirect->setPath('*/*/');
            }
        }

        $resultPage = $this->resultPageFactory->create();
        $resultPage->addBreadcrumb(
            $id ? __('Edit Pixel') : __('New Pixel ID'),
            $id ? __('Edit Pixel') : __('New Pixel ID')
        );
        $resultPage->getConfig()->getTitle()->prepend(__('Pixel'));
        $resultPage->getConfig()->getTitle()->prepend(
            $id ?
                __('Edit Pixel "%1" (ID: %2)', $model->getPixelId(), $model->getEntityId())
                : __('New Pixel ID')
        );

        return $resultPage;
    }
}
