<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Facebook Pixel Base for Magento 2
 */

namespace Amasty\FacebookPixel\Api;

use Amasty\FacebookPixel\Api\Data\PixelInterface;
use Magento\Framework\Api\SearchCriteriaInterface;
use Magento\Framework\Api\SearchResultsInterface;
use Magento\Framework\Exception;

interface PixelRepositoryInterface
{
    /**
     * @param PixelInterface $pixel
     * @return PixelInterface
     * @throws Exception\CouldNotSaveException
     */
    public function save(PixelInterface $pixel): PixelInterface;

    /**
     * @param int $entityId
     * @return PixelInterface
     * @throws Exception\NoSuchEntityException
     */
    public function getById(int $entityId): PixelInterface;

    /**
     * @param int $entityId
     * @return PixelInterface|null
     */
    public function findById(int $entityId): ?PixelInterface;

    /**
     * @param SearchCriteriaInterface $searchCriteria
     * @return SearchResultsInterface
     * @throws Exception\LocalizedException
     */
    public function getList(SearchCriteriaInterface $searchCriteria): SearchResultsInterface;

    /**
     * @param PixelInterface $pixel
     * @return bool
     * @throws Exception\CouldNotDeleteException
     */
    public function delete(PixelInterface $pixel): bool;

    /**
     * @param int $entityId
     * @return bool
     * @throws Exception\NoSuchEntityException
     * @throws Exception\CouldNotDeleteException
     */
    public function deleteById(int $entityId): bool;
}
