<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Facebook Pixel Base for Magento 2
 */

namespace Amasty\FacebookPixel\Api\Data;

use Magento\Framework\Api\ExtensibleDataInterface;

interface PixelInterface extends ExtensibleDataInterface
{
    const MAIN_TABLE = 'amasty_fbpixel_pixels';
    const STORES_TABLE = 'amasty_fbpixel_pixel_store';

    const STORE_PIXEL_ID_FIELD = 'pixel_entity_id';
    const STORE_ID_FIELD = 'store_id';

    const ENTITY_ID = 'entity_id';
    const PIXEL_ID = 'pixel_id';
    const IS_ACTIVE = 'is_active';
    const IS_CATEGORY_VIEW_ENABLED = 'is_category_view_enabled';
    const IS_PRODUCT_VIEW_ENABLED = 'is_product_view_enabled';
    const IS_INIT_CHECKOUT_ENABLED = 'is_initiate_checkout_enabled';
    const IS_PURCHASE_ENABLED = 'is_purchase_enabled';
    const IS_SEARCH_ENABLED = 'is_search_enabled';
    const IS_ADD_TO_CART_ENABLED = 'is_add_to_cart_enabled';
    const IS_ADD_TO_WISHLIST_ENABLED = 'is_add_to_wishlist_enabled';
    const IS_REGISTRATION_ENABLED = 'is_registration_enabled';
    const STORES = 'stores';

    /**
     * @param int $entityId
     * @return PixelInterface
     */
    public function setId(int $entityId): PixelInterface;

    /**
     * @return int|null
     */
    public function getId(): ?int;

    /**
     * @param string $pixelId
     * @return PixelInterface
     */
    public function setPixelId(string $pixelId): PixelInterface;

    /**
     * @return string|null
     */
    public function getPixelId(): ?string;

    /**
     * @param bool $isEnabled
     * @return PixelInterface
     */
    public function setIsCategoryViewEnabled(bool $isEnabled): PixelInterface;

    /**
     * @return bool|null
     */
    public function getIsCategoryViewEnabled(): ?bool;

    /**
     * @param bool $isEnabled
     * @return PixelInterface
     */
    public function setIsProductViewEnabled(bool $isEnabled): PixelInterface;

    /**
     * @return bool|null
     */
    public function getIsProductViewEnabled(): ?bool;

    /**
     * @param bool $isEnabled
     * @return PixelInterface
     */
    public function setIsInitiateCheckoutEnabled(bool $isEnabled): PixelInterface;

    /**
     * @return bool|null
     */
    public function getIsInitiateCheckoutEnabled(): ?bool;

    /**
     * @param bool $isEnabled
     * @return PixelInterface
     */
    public function setIsPurchaseEnabled(bool $isEnabled): PixelInterface;

    /**
     * @return bool|null
     */
    public function getIsPurchaseEnabled(): ?bool;

    /**
     * @param bool $isEnabled
     * @return PixelInterface
     */
    public function setIsSearchEnabled(bool $isEnabled): PixelInterface;

    /**
     * @return bool|null
     */
    public function getIsSearchEnabled(): ?bool;

    /**
     * @param bool $isEnabled
     * @return PixelInterface
     */
    public function setIsAddToCartEnabled(bool $isEnabled): PixelInterface;

    /**
     * @return bool|null
     */
    public function getIsAddToCartEnabled(): ?bool;

    /**
     * @param bool $isEnabled
     * @return PixelInterface
     */
    public function setIsAddToWishlistEnabled(bool $isEnabled): PixelInterface;

    /**
     * @return bool|null
     */
    public function getIsAddToWishlistEnabled(): ?bool;

    /**
     * @param bool $isEnabled
     * @return PixelInterface
     */
    public function setIsRegistrationEnabled(bool $isEnabled): PixelInterface;

    /**
     * @return bool|null
     */
    public function getIsRegistrationEnabled(): ?bool;

    /**
     * @param bool $isEnabled
     * @return PixelInterface
     */
    public function setIsActive(bool $isActive): PixelInterface;

    /**
     * @return bool|null
     */
    public function getIsActive(): ?bool;

    /**
     * @return array|null
     */
    public function getStores(): ?array;

    /**
     * @param mixed $stores
     * @return PixelInterface
     */
    public function setStores($stores): PixelInterface;

    /**
     * Retrieve existing extension attributes object or create a new one.
     * @return \Amasty\FacebookPixel\Api\Data\PixelExtensionInterface|null
     */
    public function getExtensionAttributes();

    /**
     * Set an extension attributes object.
     * @param \Amasty\FacebookPixel\Api\Data\PixelExtensionInterface $extensionAttributes
     * @return $this
     */
    public function setExtensionAttributes(
        PixelExtensionInterface $extensionAttributes
    );
}
