<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Export Pro for Magento 2 (System)
 */

namespace Amasty\ExportPro\Export\Template\Type\Xlsx;

use Magento\Framework\DataObject;

class Config extends DataObject implements ConfigInterface
{
    public const SETTING_HAS_HEADER_ROW = true;
    public const SETTING_POSTFIX = '.';
    public const SETTING_COMBINE_CHILD_ROWS = false;
    public const SETTING_CHILD_ROW_SEPARATOR = ',';

    public const HAS_HEADER_ROW = 'has_header_row';
    public const POSTFIX = 'postfix';
    public const COMBINE_CHILD_ROWS = 'combine_child_rows';
    public const CHILD_ROW_SEPARATOR = 'child_row_separator';
    public const DUPLICATE_PARENT_DATA = 'duplicate_parent_data';

    public function isHasHeaderRow(): ?bool
    {
        return $this->getData(self::HAS_HEADER_ROW) ?? self::SETTING_HAS_HEADER_ROW;
    }

    public function setHasHeaderRow(?bool $hasHeaderRow): ConfigInterface
    {
        $this->setData(self::HAS_HEADER_ROW, $hasHeaderRow);

        return $this;
    }

    public function getPostfix(): ?string
    {
        return $this->getData(self::POSTFIX) ?? self::SETTING_POSTFIX;
    }

    public function setPostfix(?string $postfix): ConfigInterface
    {
        $this->setData(self::POSTFIX, $postfix);

        return $this;
    }

    public function isCombineChildRows(): ?bool
    {
        return $this->getData(self::COMBINE_CHILD_ROWS) ?? self::SETTING_COMBINE_CHILD_ROWS;
    }

    public function setCombineChildRows(?bool $combineChildRows): ConfigInterface
    {
        $this->setData(self::COMBINE_CHILD_ROWS, $combineChildRows);

        return $this;
    }

    public function getChildRowSeparator(): ?string
    {
        return $this->getData(self::CHILD_ROW_SEPARATOR) ?? self::SETTING_CHILD_ROW_SEPARATOR;
    }

    public function setChildRowSeparator(?string $childRowSeparator): ConfigInterface
    {
        $this->setData(self::CHILD_ROW_SEPARATOR, $childRowSeparator);

        return $this;
    }

    public function isDuplicateParentData(): ?bool
    {
        return $this->getData(self::DUPLICATE_PARENT_DATA);
    }

    public function setDuplicateParentData(?bool $duplicate): ConfigInterface
    {
        $this->setData(self::DUPLICATE_PARENT_DATA, $duplicate);

        return $this;
    }
}
