<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Export Pro for Magento 2 (System)
 */

namespace Amasty\ExportPro\Block\Adminhtml\Job\Edit;

use Amasty\ExportPro\Model\Job\Job;
use Magento\Framework\App\RequestInterface;
use Magento\Framework\View\Element\UiComponent\Control\ButtonProviderInterface;

class SaveAndRun implements ButtonProviderInterface
{
    /**
     * @var RequestInterface
     */
    private $request;

    public function __construct(
        RequestInterface $request
    ) {
        $this->request = $request;
    }

    /**
     * @return array
     */
    public function getButtonData()
    {
        $jobId = (int)$this->request->getParam(Job::JOB_ID);

        if (!$jobId) {
            return [];
        }

        return [
            'label' => __('Save and Generate'),
            'class' => 'save',
            'data_attribute' => [
                'mage-init' => [
                    'Magento_Ui/js/form/button-adapter' => [
                        'actions' => [
                            [
                                'targetName' => 'export_job_form.export_job_form',
                                'actionName' => 'saveAndRun'
                            ]
                        ]
                    ]
                ],
            ],
            'on_click' => ''
        ];
    }
}
