<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Exit Intent Popup for Magento 2
 */

namespace Amasty\ExitPopup\Model;

use Amasty\Base\Model\ConfigProviderAbstract;
use Magento\Newsletter\Model\Subscriber;
use Magento\Store\Model\ScopeInterface;
use Magento\Framework\App\Config\ScopeConfigInterface;

class ConfigProvider extends ConfigProviderAbstract
{
    /**
     * xpath prefix of module (section)
     * @var array
     */
    protected $pathPrefix = 'amasty_exit_popup/';

    /**#@+
     * xpath group parts
     */
    public const GENERAL_BLOCK = 'general/';
    public const PROMO_SETTINGS_BLOCK = 'promo_settings/';
    public const EMAIL_SETTINGS_BLOCK = 'email_settings/';
    /**#@-*/

    /**#@+
     * xpath field parts
     */
    public const EXIT_POPUP_ENABLED = 'enable';

    public const EXIT_POPUP_TITLE = 'title';
    public const EXIT_POPUP_TEXT = 'text';
    public const EXIT_POPUP_PAGES = 'pages';
    public const RECOVERY_TIME = 'recovery_time';
    public const CUSTOM_TIME = 'custom_time';

    public const PROMO_TYPE_FIELD = 'promo_type';
    public const RULE_ID_FIELD = 'rule_id';
    public const PRODUCT_ID = 'downloadable_product_id';
    public const ASK_ENABLED = 'enable_ask';
    public const CONSENT_MESSAGE = 'consent_message';

    public const SENDER_EMAIL = 'email_sender';
    public const EMAIL_TEMPLATE = 'template';
    /**#@-*/

    /**
     * @return bool
     */
    public function isExitPopupEnabled()
    {
        return $this->isSetFlag(self::GENERAL_BLOCK . self::EXIT_POPUP_ENABLED);
    }

    /**
     * @return string
     */
    public function getExitPopupTitle()
    {
        return (string)$this->getValue(self::GENERAL_BLOCK . self::EXIT_POPUP_TITLE);
    }

    /**
     * @return string
     */
    public function getExitPopupText()
    {
        return (string)$this->getValue(self::GENERAL_BLOCK . self::EXIT_POPUP_TEXT);
    }

    /**
     * @return array
     */
    public function getPopupPages()
    {
        $value = $this->getValue(self::GENERAL_BLOCK . self::EXIT_POPUP_PAGES);
        if ($value !== null) {
            return explode(',', $value);
        }

        return [];
    }

    /**
     * @return int
     */
    public function getRecoveryTime()
    {
        return $this->getValue(self::GENERAL_BLOCK . self::RECOVERY_TIME);
    }

    /**
     * @return int
     */
    public function getCustomTime()
    {
        return $this->getValue(self::GENERAL_BLOCK . self::CUSTOM_TIME);
    }

    /**
     * @return string
     */
    public function getPromoType()
    {
        return $this->getValue(self::PROMO_SETTINGS_BLOCK . self::PROMO_TYPE_FIELD);
    }

    /**
     * @return int
     */
    public function getRuleId()
    {
        return $this->getValue(self::PROMO_SETTINGS_BLOCK . self::RULE_ID_FIELD);
    }

    /**
     * @return string
     */
    public function getProductId()
    {
        return $this->getValue(self::PROMO_SETTINGS_BLOCK . self::PRODUCT_ID);
    }

    /**
     * @return bool
     */
    public function isAskEnabled()
    {
        return $this->isSetFlag(self::PROMO_SETTINGS_BLOCK . self::ASK_ENABLED);
    }

    /**
     * @return string
     */
    public function getConsentMessage()
    {
        return $this->getValue(self::PROMO_SETTINGS_BLOCK . self::CONSENT_MESSAGE);
    }

    /**
     * @return string
     */
    public function getEmailSender()
    {
        return $this->getValue(self::EMAIL_SETTINGS_BLOCK . self::SENDER_EMAIL);
    }

    /**
     * @return string
     */
    public function getEmailTemplate()
    {
        return $this->getValue(self::EMAIL_SETTINGS_BLOCK . self::EMAIL_TEMPLATE);
    }

    /**
     * @return bool
     */
    public function allowGuestSubscribe()
    {
        return (bool)$this->scopeConfig->getValue(
            Subscriber::XML_PATH_ALLOW_GUEST_SUBSCRIBE_FLAG,
            ScopeInterface::SCOPE_STORE
        );
    }
}
