<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Exit Intent Popup for Magento 2
 */

namespace Amasty\ExitPopup\Model\Config\Source;

use Magento\Framework\Option\ArrayInterface;

class TimeSource implements ArrayInterface
{
    public const FIFTEEN_MINUTES = 0;
    public const THIRTY_MINUTES = 1;
    public const ONE_HOUR = 2;
    public const TWO_HOURS = 3;
    public const FOUR_HOURS = 4;
    public const EIGHT_HOURS = 5;
    public const ONE_DAY = 6;
    public const ONE_WEEK = 7;
    public const CUSTOM = 8;

    /**
     * @inheritdoc
     */
    public function toOptionArray()
    {
        return [
            ['value' => self::FIFTEEN_MINUTES, 'label' => __('15 minutes')],
            ['value' => self::THIRTY_MINUTES, 'label' => __('30 minutes')],
            ['value' => self::ONE_HOUR, 'label' => __('1 hour')],
            ['value' => self::TWO_HOURS, 'label' => __('2 hours')],
            ['value' => self::FOUR_HOURS, 'label' => __('4 hours')],
            ['value' => self::EIGHT_HOURS, 'label' => __('8 hours')],
            ['value' => self::ONE_DAY, 'label' => __('1 day')],
            ['value' => self::ONE_WEEK, 'label' => __('1 week')],
            ['value' => self::CUSTOM, 'label' => __('Custom')]
        ];
    }
}
