<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Exit Intent Popup for Magento 2
 */

namespace Amasty\ExitPopup\Model\Config\Source;

use Magento\Framework\Option\ArrayInterface;

class PromoSource implements ArrayInterface
{
    public const COUPON_CODE_VALUE = 0;
    public const PRODUCT_VALUE = 1;

    /**
     * @inheritdoc
     */
    public function toOptionArray()
    {
        return [
            ['value' => self::COUPON_CODE_VALUE, 'label' => __('Coupon Code')],
            ['value' => self::PRODUCT_VALUE, 'label' => __('Downloadable Product')],
        ];
    }
}
