<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Exit Intent Popup for Magento 2
 */

namespace Amasty\ExitPopup\Model\Config\Source;

use Magento\Framework\Data\OptionSourceInterface;

class PagesSource implements OptionSourceInterface
{
    public const CART_VALUE = 0;
    public const CHECKOUT_VALUE = 1;
    public const PAYPAL_VALUE = 2;

    /**
     * @inheritdoc
     */
    public function toOptionArray()
    {
        return [
            ['value' => self::CART_VALUE, 'label' => __('Shopping Cart')],
            ['value' => self::CHECKOUT_VALUE, 'label' => __('Checkout')],
            ['value' => self::PAYPAL_VALUE, 'label' => __('PayPal Express Checkout (Review Page)')]
        ];
    }
}
