<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Exit Intent Popup for Magento 2
 */

namespace Amasty\ExitPopup\Api;

interface PopupManagementInterface
{
    /**#@+
     * Defined $pageValue values
     */
    public const CART = 'cart';
    public const CHECKOUT = 'checkout';
    /**#@-*/

    /**
     * @return array
     */
    public function getPopupData();

    /**
     * @param int $pageValue
     *
     * @return bool
     */
    public function isVisible($pageValue);
}
