<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package ElasticSearch Catalog Permissions (System)
*/

declare(strict_types=1);

namespace Amasty\ElasticsearchCatalogPermissions\Plugin\ElasticSearch\Model\Indexer\Structure\EntityBuilder\Product;

use Amasty\ElasticSearch\Model\Indexer\Structure\EntityBuilder\Product;
use Amasty\ElasticsearchCatalogPermissions\Model\CategoryPermission\GetFieldName;
use Magento\Customer\Model\ResourceModel\Group\CollectionFactory as GroupCollectionFactory;
use Magento\Elasticsearch\Model\Adapter\FieldMapper\Product\FieldProvider\FieldType\ConverterInterface;
use Magento\Store\Model\ResourceModel\Store\CollectionFactory as StoreCollectionFactory;

class CategoryPermissionsFieldMapper
{
    /**
     * @var ConverterInterface
     */
    private $fieldTypeConverter;

    /**
     * @var StoreCollectionFactory
     */
    private $storeCollectionFactory;

    /**
     * @var GroupCollectionFactory
     */
    private $groupCollectionFactory;

    /**
     * @var GetFieldName
     */
    private $getFieldName;

    public function __construct(
        ConverterInterface $fieldTypeConverter,
        StoreCollectionFactory $storeCollectionFactory,
        GroupCollectionFactory $groupCollectionFactory,
        GetFieldName $getFieldName
    ) {
        $this->fieldTypeConverter = $fieldTypeConverter;
        $this->storeCollectionFactory = $storeCollectionFactory;
        $this->groupCollectionFactory = $groupCollectionFactory;
        $this->getFieldName = $getFieldName;
    }

    /**
     * @see Product::buildEntityFields()
     *
     * @param Product $subject
     * @param array $result
     * @return array
     * @SuppressWarnings(PHPMD.UnusedFormalParameter)
     */
    public function afterBuildEntityFields(Product $subject, array $result): array
    {
        $groups = $this->groupCollectionFactory->create()->getAllIds();
        $stores = $this->storeCollectionFactory->create()->getAllIds();

        foreach ($stores as $storeId) {
            foreach ($groups as $groupId) {
                $categoryPermissionKey = $this->getFieldName->execute((int)$storeId, (int)$groupId);
                $result[$categoryPermissionKey] = [
                    'type' => $this->fieldTypeConverter->convert(
                        ConverterInterface::INTERNAL_DATA_TYPE_INT
                    )
                ];
            }
        }

        return $result;
    }
}
