<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package ElasticSearch Catalog Permissions (System)
*/

declare(strict_types=1);

namespace Amasty\ElasticsearchCatalogPermissions\Plugin\ElasticSearch\Model\Indexer\Data\Product\ProductDataMapper;

use Amasty\ElasticSearch\Model\Indexer\Data\Product\ProductDataMapper;
use Amasty\ElasticsearchCatalogPermissions\Model\CategoryPermission\GetFieldName;
use Amasty\ElasticsearchCatalogPermissions\Model\CategoryPermission\GetProductIndexData;

class CategoryPermissionsDataMapper
{
    /**
     * @var GetFieldName
     */
    private $getFieldName;

    /**
     * @var GetProductIndexData
     */
    private $getProductIndexData;

    public function __construct(
        GetFieldName $getFieldName,
        GetProductIndexData $getProductIndexData
    ) {
        $this->getFieldName = $getFieldName;
        $this->getProductIndexData = $getProductIndexData;
    }

    /**
     * @see ProductDataMapper::map()
     *
     * @param ProductDataMapper $subject
     * @param array $result
     * @param array $documentData
     * @param int $storeId
     * @param array $context
     * @return array
     * @SuppressWarnings(PHPMD.UnusedFormalParameter)
     */
    public function afterMap(
        ProductDataMapper $subject,
        array $result,
        array $documentData,
        int $storeId,
        array $context = []
    ): array {
        $productIds = array_keys($result);
        $indexData = $this->getProductIndexData->execute($productIds, $storeId);

        foreach ($result as $productId => $document) {
            // phpcs:ignore Magento2.Performance.ForeachArrayMerge.ForeachArrayMerge
            $document = array_merge($document, $this->getCategoryPermissionsData($productId, $storeId, $indexData));
            $result[$productId] = $document;
        }

        return $result;
    }

    private function getCategoryPermissionsData(int $productId, int $storeId, array $indexData): array
    {
        if (!isset($indexData[$productId])) {
            return [];
        }

        $result = [];

        foreach ($indexData[$productId] as $groupId => $value) {
            $categoryPermissionKey = $this->getFieldName->execute($storeId, $groupId);
            $result[$categoryPermissionKey] = $value;
        }

        return $result;
    }
}
