<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package ElasticSearch Catalog Permissions (System)
*/

declare(strict_types=1);

namespace Amasty\ElasticsearchCatalogPermissions\Model\CategoryPermission;

use Magento\CatalogPermissions\Model\ResourceModel\Permission\Index;

class GetProductIndexData
{
    /**
     * @var Index
     */
    private $categoryPermissionsIndex;

    /**
     * @param Index $categoryPermissionsIndex
     */
    public function __construct(
        Index $categoryPermissionsIndex
    ) {
        $this->categoryPermissionsIndex = $categoryPermissionsIndex;
    }

    /**
     * Prepare system index data for products.
     *
     * @param array $productIds
     * @param int $storeId
     * @return array
     */
    public function execute(array $productIds, int $storeId): array
    {
        $data = $this->categoryPermissionsIndex->getIndexForProduct($productIds, null, $storeId);
        $result = [];

        foreach ($data as $row) {
            $result[$row['product_id']][$row['customer_group_id']] = $row['grant_catalog_category_view'];
        }

        return $result;
    }
}
