<?php

declare(strict_types=1);

namespace Amasty\EavImportEntity\Import\DataHandling\RowModifier\Eav;

use Amasty\ImportCore\Api\Modifier\RowModifierInterface;
use Amasty\EavImportEntity\Import\DataHandling\AttributeCodeToId;

class EntityAttribute implements RowModifierInterface
{
    /**
     * @var AttributeCodeToId
     */
    private $attributeCodeToId;

    public function __construct(AttributeCodeToId $attributeCodeToId)
    {
        $this->attributeCodeToId = $attributeCodeToId;
    }

    /**
     * @inheritDoc
     */
    public function transform(array &$row): array
    {
        return $this->attributeCodeToId->executeRow($row, 'attribute_id');
    }
}
