define([
    'uiComponent',
    'jquery',
    'mage/translate',
], function (Component, $) {

    return Component.extend({
        defaults: {
            history: '#amasty_perm_order_dealer_comment_history_dealer',
            comment: '#amasty_perm_order_dealer_comment_history_comment',
            notify: '#amasty_perm_order_dealer_comment_history_notify',
            commentBlock: '#amasty_perm_order_dealer_comment_block'
        },
        initialize: function () {
            this._super();
            this.addEvents();
            this.setSelected();
            this.showHistory();
        },

        addEvents: function () {
            $(this.history).on('change', this.showHistory.bind(this));
            $('#amasty-add-comment').on('click', this.addComment.bind(this));
        },

        setSelected: function () {
            $('[name^=dealer-history-] option:selected').each(function () {
                $(this.history).val(this.dataset.dealerId);
            });
        },

        hideHistory: function () {
            $('[name^=dealer-history-]').each(function () {
                this.hide();
            });
        },

        showHistory: function () {
            this.hideHistory();
            $('[name=dealer-history-' + this.getDealerId() + ']').show();
        },

        assignDealers: function () {
            this.ajaxCall();
        },

        getCommentData: function () {
            var commentData = {
                'comment': $(this.comment).val(),
                'is_dealer_notified': $(this.notify).is(':checked') ? 1 : 0
            };

            if ($(this.history).val()) {
                commentData['dealer_id'] = $(this.history).val();
            }

            return commentData;
        },

        getDealerId: function () {
            if ($('input[name="dealer_id"]').val()) {
                dealer_id = $('input[name="dealer_id"]').val();
            } else {
                dealer_id = $(this.history).val();
            }

            return dealer_id;
        },

        addComment: function () {
            var self = this;
            $.ajax({
                url: this.submitCommentUrl,
                showLoader: true,
                data: this.getCommentData(),
                success: function (response) {
                    if (response.error) {
                        alert(response.message);
                        this.showHistory();
                    } else {
                        $(self.commentBlock).html(response);
                        $(self.comment).val('');
                        self.showHistory();
                    }
                }.bind(this)
            });
        }
    });
});
