define([
    'uiComponent',
    'jquery',
    'mage/translate',
], function (Component, $) {

    return Component.extend({
        defaults: {
            alreadySelected: {},
            changedSelects: {},
            assignDealerSelector: '#amasty-assign-dealers'
        },

        initialize: function () {
            this._super();
            $(this.assignDealerSelector).hide();
            this.addEvents();
            this.saveAlreadySelected();
        },

        saveAlreadySelected: function () {
            _.each($('[name = amasty_perm_order_item_dealer]').find('option:selected'), function (option) {
                this.alreadySelected[option.dataset.orderItemId] = option.value;
            }, this);
        },

        addEvents: function () {
            $(this.assignDealerSelector).on('click', this.assignDealers.bind(this));
            $('[name = amasty_perm_order_item_dealer]').on('change', this.saveSelects.bind(this));
        },

        saveSelects: function () {
            $('.col-dealers .message').remove();
            var orderItemId = $(event.target).find('option:selected').data().orderItemId,
                dealerId = $(event.target).find('option:selected').val();
            if (this.alreadySelected[orderItemId] !== dealerId) {
                this.changedSelects[orderItemId] = dealerId;
            } else {
                delete this.changedSelects[orderItemId];
            }
            !_.isEmpty(this.changedSelects) ? $(this.assignDealerSelector).show() : $(this.assignDealerSelector).hide();
        },

        assignDealers: function () {
            this.ajaxCall();
        },

        ajaxCall: function () {
            $('.col-dealers .message').remove();
            var dealersData = this.changedSelects;
            $.ajax({
                url: this.submitUrl,
                type: 'POST',
                showLoader: true,
                data: {dealersData},
                success: function (response) {
                    $(this.assignDealerSelector).hide();
                    if (!_.isEmpty(response.yes)) {
                        this.showSuccess(response.yes);
                    }
                    if (!_.isEmpty(response.failed)) {
                        this.showError(response.failed);
                    }
                    if (!_.isEmpty(response.no)) {
                        this.showNo(response.no);
                    }
                    this.changedSelects = {};
                    this.saveAlreadySelected();
                }.bind(this)
            });
        },

        showSuccess: function (orderItemIds) {
            _.each(orderItemIds, function (orderItemId) {
                $('.amasty_order_item_id' + orderItemId).text($.mage.__('Yes'));
                $('[data-order-item-id=' + orderItemId + ']').closest('.amasty_perm_order_item_dealer_block').append(
                    '<div class="message">' + $.mage.__('You assigned dealers.') + '</div>'
                );
            });
        },

        showError: function (orderItemIds) {
            _.each(orderItemIds, function (orderItemId) {
                $('.amasty_order_item_id' + orderItemId).text($.mage.__('Failed'));
                $('[data-order-item-id=' + orderItemId + ']').closest('.amasty_perm_order_item_dealer_block').append(
                    '<div class="message">' + $.mage.__('Something went wrong.') + '</div>'
                );
            });
        },

        showNo: function (orderItemIds) {
            _.each(orderItemIds, function (orderItemId) {
                $('.amasty_order_item_id' + orderItemId).text($.mage.__('No'));
            });
        }
    });
});
